# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sdpackage import *
from .sdapiobject import *
from .sdapiobject import *
from .apiexception import APIException

class SDPackageDependency(SDAPIObject):
    """
    Class used to store information about a SDPackage dependency.
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDPackageDependency
        """
        super(SDPackageDependency, self).__init__(APIContext, handle, *args, **kwargs)

    def getFilePath(self) -> str:
        """
        Get the package file path

        """
        outFilePath = ctypes.c_char_p()
        _res = self.mAPIContext.SDPackageDependency_getFilePath(self.mHandle, ctypes.byref(outFilePath))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outFilePath.value.decode('utf-8') # type: ignore

    def getPackage(self) -> Optional[SDPackage]:
        """
        Get the package

        """
        outSDPackage = ctypes.c_void_p()
        _res = self.mAPIContext.SDPackageDependency_getPackage(self.mHandle, ctypes.byref(outSDPackage))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDPackage, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDPackage.value, ownHandle=True)

